# Ćwiczenie 3

## Zadanie
Przyjmij założenie o istnieniu prostej funkcji logowania, która ma przedstawioną tutaj postać:

```go
func Log(ctx context.Context, level Level, message string) {
    var inLevel Level
    // TODO - pobranie poziomu logowania z kontekstu i przypisanie go elementowi inLevel
	if level == Debug && inLevel == Debug {
        fmt.Println(message)
    }
    if level == Info && (inLevel == Debug || inLevel == Info) {
        fmt.Println(message)
    }
}
```

Zdefiniuj typ o nazwie `Level` bazujący na typie `string`. Zdefiniuj dla polecenia dla tego typu, `Debug` i `Info`, oraz zdefiniuj je jako odpowiednio `"debug"` i `"info"`.

Utwórz funkcję przeznaczoną do przechowywania w kontekście informacji o poziomie logowania i wyodrębnij je.

Utwórz funkcję oprogramowania pośredniczącego w celu pobrania poziomu logowania z parametru zapytania o nazwie `log_level`. Poprawnymi wartościami dla `log_lvel` są `debug` i `info`.

Umieść `TODO` w `Log` i poprawnie wyodrębnij z kontekstu informacje dotyczące poziomu logowania. Jeżeli poziom logowania nie został określony bądź ma niepoprawną wartość, nie powinny być wyświetlone żadne informacje

## Rozwiązanie

Rozpocznij od zdefiniowania typu `Level` i jego stałych:

```go
type Level string

const (
	Debug Level = "debug"
	Info  Level = "info"
)
```

Następnie utwórz funkcje przeznaczone do zarządzania kontekstem poziomu logowania. Najpierw zdefiniuj typ nieeksportowany i nieeksportowaną stałą dla klucza.

```go
type logKey int

const (
	_ logKey = iota
	key
)
```

Następnie użyjemy dwóch zdefiniowanych typów do utworzenia funkcji zarządzania kontekstem.

```go
func ContextWithLevel(ctx context.Context, level Level) context.Context {
	return context.WithValue(ctx, key, level)
}

func LevelFromContext(ctx context.Context) (Level, bool) {
	level, ok := ctx.Value(key).(Level)
	return level, ok
}
```

Teraz można użyć funkcję `ContextWithLevel` i typ `Level` do utworzenia oprogramowania pośredniczącego:

```go
func Middleware(h http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		level := r.URL.Query().Get("log_level")
		ctx := ContextWithLevel(r.Context(), Level(level))
		r = r.WithContext(ctx)
		h.ServeHTTP(w, r)
	})
}
```

Pozostało już tylko wypełnienie brakujących wierszy w funkcji `Log` używając do tego `LevelFromContext`.

```go
	inLevel, ok := LevelFromContext(ctx)
	if !ok {
		return
	}
```